package info.hasper.android.minimalopencvcamera;

import org.opencv.android.BaseLoaderCallback;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.android.CameraBridgeViewBase.CvCameraViewFrame;
import org.opencv.android.CameraBridgeViewBase.CvCameraViewListener2;
import org.opencv.android.LoaderCallbackInterface;
import org.opencv.android.OpenCVLoader;
import org.opencv.core.Mat;

import android.app.Activity;
import android.os.Bundle;
/**
 * A minimal example showing how to access the camera image
 * using OpenCV {@link http://opencv.org/platforms/android.html}
 * @author Philipp Hasper
 */
public class MainActivity extends Activity implements CvCameraViewListener2 {
	private CameraBridgeViewBase cameraView;

	private BaseLoaderCallback mLoaderCallback = new BaseLoaderCallback(this) {
		@Override
		public void onManagerConnected(int status) {
			switch (status) {
			case LoaderCallbackInterface.SUCCESS:
			{
				cameraView.enableView();
			} break;
			default:
			{
				super.onManagerConnected(status);
			} break;
			}
		}
	};

	@Override
	public void onResume()
	{
		super.onResume();
		OpenCVLoader.initAsync(OpenCVLoader.OPENCV_VERSION_2_4_9, this, mLoaderCallback);
	}


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		cameraView = (CameraBridgeViewBase) findViewById(R.id.cameraView);
		cameraView.setCvCameraViewListener(this);
	}
	@Override
	public void onPause()
	{
		super.onPause();
		if (cameraView != null)
			cameraView.disableView();
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		if (cameraView != null)
			cameraView.disableView();
	}

	@Override
	public void onCameraViewStarted(int width, int height) {
	}

	@Override
	public void onCameraViewStopped() {
	}

	@Override
	public Mat onCameraFrame(CvCameraViewFrame inputFrame) {
		/*
		 * TODO: now process the frame
		 */
		 return inputFrame.rgba();
	}
}